/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.engine;

import com.quantumdata.sct.dao.vo.ParameterVO;
import com.quantumdata.sct.engine.IEngineContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;

public abstract class AbstractEngineContext
implements IEngineContext {
    protected IEngineContext parentContext;
    protected ArrayList inputParams = new ArrayList();
    protected ArrayList outputParams = new ArrayList();
    protected Properties contextProps;

    protected AbstractEngineContext() {
    }

    protected AbstractEngineContext(IEngineContext iEngineContext) {
        this();
        this.parentContext = iEngineContext;
    }

    public void copyFrom(IEngineContext iEngineContext, boolean bl, boolean bl2) {
        ParameterVO parameterVO;
        if (iEngineContext == null) {
            throw new IllegalArgumentException();
        }
        if (bl) {
            for (ParameterVO parameterVO2 : this.inputParams) {
                if (parameterVO2.getName() == null) continue;
                parameterVO = iEngineContext.getParameter(parameterVO2.getName());
                if (parameterVO != null && parameterVO.getValue() != null) {
                    parameterVO2.setValue(parameterVO.getValue());
                }
                if (parameterVO == null) continue;
                parameterVO2.setUserInput(parameterVO.isUserInput());
            }
        }
        if (bl2) {
            for (ParameterVO parameterVO2 : this.outputParams) {
                if (parameterVO2.getName() == null) continue;
                parameterVO = iEngineContext.getParameter(parameterVO2.getName());
                if (parameterVO != null && parameterVO.getValue() != null) {
                    parameterVO2.setValue(parameterVO.getValue());
                }
                if (parameterVO == null) continue;
                parameterVO2.setUserInput(parameterVO.isUserInput());
            }
        }
    }

    public Collection getInputParameters() {
        return this.inputParams;
    }

    public Collection getOutputParameters() {
        return this.outputParams;
    }

    public void addInputParameter(ParameterVO parameterVO) {
        if (parameterVO == null) {
            throw new IllegalArgumentException();
        }
        String string = parameterVO.getName();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.inputParams.add(parameterVO);
    }

    public void addOutputParameter(ParameterVO parameterVO) {
        if (parameterVO == null) {
            throw new IllegalArgumentException();
        }
        String string = parameterVO.getName();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.outputParams.add(parameterVO);
    }

    public ParameterVO getInputParameter(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        for (ParameterVO parameterVO : this.inputParams) {
            if (!string.equals(parameterVO.getName())) continue;
            return parameterVO;
        }
        return null;
    }

    public ParameterVO getOutputParameter() {
        if (this.outputParams.isEmpty()) {
            return null;
        }
        return (ParameterVO)this.outputParams.get(0);
    }

    public ParameterVO getOutputParameter(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        for (ParameterVO parameterVO : this.outputParams) {
            if (!string.equals(parameterVO.getName())) continue;
            return parameterVO;
        }
        return null;
    }

    public ParameterVO getParameter(String string) {
        ParameterVO parameterVO = this.getInputParameter(string);
        if (parameterVO == null) {
            parameterVO = this.getOutputParameter(string);
        }
        return parameterVO;
    }

    public void removeInputParameter(String string) {
        this.inputParams.remove(this.getInputParameter(string));
    }

    public void removeOutputParameter(String string) {
        this.outputParams.remove(this.getOutputParameter(string));
    }

    public IEngineContext getParentEngineContext() {
        return this.parentContext;
    }

    public Properties getProperties() {
        return this.contextProps;
    }
}

